<?php
/**
 * The template for displaying 404 pages (Not Found).
 *
 * @package _tk
 */

get_header(); ?>

	<div class="container">
		<section class="content-padder error-404 not-found">

			<?php if (!get_field('404_title_not','option')) { ?>
				<header>
					<h2 class="page-title">
						<?php if (get_field('404_title','option')) {
							the_field('404_title','option');
						} else {
							_e( 'Oops! Something went wrong here.', '_tk' );
						}
						?>
					</h2>
				</header><!-- .page-header -->
			<?php } ?>

			<div class="page-content">
				<?php if (!get_field('404_text_not','option')) { ?>
					<?php if (get_field('404_text','option')) {
						the_field('404_text','option');
					} else { ?>
						<p><?php _e( 'Nothing could be found at this location. Maybe try a search?', '_tk' ); ?></p>
					<?php } ?>
				<?php } ?>
				
				<?php $elements_404 = get_field('404_elements','option');
				$blog_columns = get_field('404_blog_columns','option'); ?>
	
				<?php if ($elements_404 && is_array($elements_404) && in_array('searchform', $elements_404)) { ?>
					<?php get_search_form(); ?>
				<?php } ?>
				
				<div class="margintop">
					<?php if ($elements_404 && is_array($elements_404) && in_array('blog', $elements_404)) { ?>
						<?php if (get_field('blog_number','option')) {
							$blog_number = get_field('blog_number','option');
						} else {
							$blog_number == -1;
						}
						$blog = new WP_Query( array (
							'post_type' => 'post',
							'post_status' => 'publish',
							'posts_per_page' => $blog_number,
							'caller_get_posts'=> 1
						) );
						
						if ( $blog->have_posts() ) : ?>
							<div class="row<?php if (get_field('blog_type','option') == 'masonry') echo ' grid grid-'.$blog_columns; ?>">
								<?php while ( $blog->have_posts() ) : $blog->the_post(); ?>
									<?php get_template_part( 'elements/content', get_post_format() ); ?>								
								<?php endwhile; ?>
							</div>
						<?php endif;
						wp_reset_query(); ?>
					<?php } ?>
					
					<?php if ($elements_404 && is_array($elements_404) && in_array('products', $elements_404)) { ?>
						<?php if (get_field('products_number','option')) {
							$products_number = get_field('products_number','option');
						} else {
							$products_number == -1;
						}
						$products = new WP_Query( array (
							'post_type' => 'product',
							'post_status' => 'publish',
							'posts_per_page' => $products_number,
							'caller_get_posts'=> 1
						) );
						
						if ( $products->have_posts() ) : ?>
							<div class="woocommerce">
								<ul class="row products">
									<?php while ( $products->have_posts() ) : $products->the_post(); ?>
										<?php wc_get_template_part( 'content', 'product' ); ?>
									<?php endwhile; ?>
								</ul>
							</div>
						<?php endif;
						wp_reset_query(); ?>
					<?php } ?>
					
					<?php if ($elements_404 && is_array($elements_404) && in_array('bestsellers', $elements_404)) { ?>
						<?php $products_number_bestseller = get_field('products_number','option');
						if ($products_number_bestseller) {
							echo do_shortcode('[best_selling_products per_page='.$products_number_bestseller.']');
						} else {
							echo do_shortcode('[best_selling_products]');
						} ?>
					<?php } ?>
				</div>

			</div><!-- .page-content -->

		</section><!-- .content-padder -->
	</div>

<?php get_footer(); ?>